function valida_titolo_abilitativo(input) {
  const val = input.val().trim();
  const id = input.attr("id");
  const $errore = $("#errore_" + id);
  const tipo_cantierabilita = $("input[name='acquisizione-pareri']:checked").val();
  const isPrimaRiga = (id === "enti_preposti_input" || id === "titolo_abilitativo_1");

  if (val.length === 0) {
    if ((tipo_cantierabilita === "necessita" && isPrimaRiga) || (tipo_cantierabilita === "necessita-forse" && isPrimaRiga)) {
      input.addClass("is-invalid");
      $errore.addClass("invalid-feedback").text("Specificare almeno un titolo abilitativo.");
    } else {
      // se non è la prima riga e il campo è vuoto, nessun errore
      input.removeClass("is-invalid");
      $errore.removeClass("invalid-feedback").text("");
    }
  } else if (val.length > 100) {
    input.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Inserire massimo 100 caratteri.");
  } else {
    input.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
  }
}

// Validazione file perizia (solo quando selezionato "no-necessita")
$(document).on("change", "#perizia_progettista", function () {
  const $file = $(this);
  const f = $file[0]?.files?.[0];
  const $err = $("#errore_perizia_progettista");

  if (!f) {
    $file.addClass("is-invalid");
    $err.addClass("invalid-feedback d-block text-danger")
        .text("Carica la perizia asseverata (PDF).");
  } else if (!/\.pdf$/i.test(f.name)) {
    $file.addClass("is-invalid");
    $err.addClass("invalid-feedback d-block text-danger")
        .text("Il file deve essere in formato PDF.");
  } else {
    $file.removeClass("is-invalid");
    $err.removeClass("invalid-feedback d-block text-danger").text("");
  }
});

function valida_documento_titolo_abilitativo(input) {
  const tipo = input.attr("type");
  const id = input.attr("id");
  const $errore = $("#errore_" + id);
  const tipo_cantierabilita = $("input[name='acquisizione-pareri']:checked").val();

  // Campo titolo associato
  const titoloId = id.includes("documento_abilitativo") 
    ? "titolo_abilitativo_" + id.match(/documento_abilitativo_(\d+)_\d+/)[1]
    : id.replace("file", "input");

  const titoloInput = $("#" + titoloId);
  const titoloVal = titoloInput.length ? titoloInput.val().trim() : "";

  // Controllo file
  const isFile = tipo === "file";
  const file = isFile ? input[0].files?.[0] : null;
  const isRilasciato = id.endsWith("_2");

  const obbligatorio =
    (tipo_cantierabilita === "necessita" && (titoloVal.length > 0 || id === "enti_preposti_file")) ||
    (tipo_cantierabilita === "necessita-forse" && titoloVal.length > 0 && isRilasciato);

  // Se non obbligatorio e campo vuoto, esci
  if (!file && !obbligatorio) {
    input.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
    return;
  }

  if (!file && obbligatorio) {
    input.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Documento titolo abilitativo obbligatorio.");
  } else if (file && !/(\.pdf)$/i.test(file.name)) {
    input.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Formato non valido. Caricare solo file .pdf.");
  } else if (file && file.size > 5 * 1024 * 1024) {
    input.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Il file deve essere inferiore a 5MB.");
  } else {
    input.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
  }
}


$(document).on("input", "input[id^=enti_preposti_input], input[id^=titolo_abilitativo_]", function () {
  valida_titolo_abilitativo($(this));
});

$(document).on("change", "input[id^=enti_preposti_file], input[id^=documento_abilitativo_]", function () {
  valida_documento_titolo_abilitativo($(this));
});

$("input[name='acquisizione-pareri']").on("change", function () {
  $("#acquisizione-pareri").removeClass("is-invalid");
  $("#errore_acquisizione_pareri").removeClass("invalid-feedback").text("");

  const val = $(this).val();
  if (val === "no-necessita") {
    $("#enti-preposti-lista").addClass("d-none");
    $("#enti-preposti-tabella").addClass("d-none");
  } else if (val === "necessita") {
    $("#enti-preposti-lista").removeClass("d-none");
    $("#enti-preposti-tabella").addClass("d-none");
  } else {
    $("#enti-preposti-lista").addClass("d-none");
    $("#enti-preposti-tabella").removeClass("d-none");
  }
});

$(document).ready(function () {
  $(".testo_tabella_richiesto_rilasciato").each(function () {
    const $row = $(this).closest("tr");
    $row.find("select").prop("disabled", true);
    $row.find('input[type="file"]').prop("disabled", true);
  });
});

$(document).on("input", ".testo_tabella_richiesto_rilasciato", function () {
  const $row = $(this).closest("tr");
  const testo = $(this).val();
  const enable = testo.trim() !== "";

  $row.find('input[type="file"]').prop("disabled", !enable);
});






// === Cantierabilità - righe dinamiche per "necessita" ===

// Contatore righe (partiamo da 1 perché la prima riga esiste già)
let epIndex = 1;

// Forza accettazione PDF sui file della prima riga
$(function(){
  $("#perizia_progettista").attr("accept", "application/pdf");
  $("input[name='enti_preposti_file']").attr("accept", "application/pdf");
});

// Aggiungi nuova riga
$(document).on("click", "#ep-add-row", function(){
  epIndex += 1;
  const i = epIndex;

  const li = $(`
    <li class="mb-3 ep-row" data-index="${i}">
      <div class="row g-3 align-items-end">
        <div class="col">
          <label class="form-label">Titolo Abilitativo</label>
          <input id="enti_preposti_input_${i}" class="form-control" type="text"
                 placeholder="Inserisci titolo abilitativo">
          <div id="errore_enti_preposti_input_${i}" class="mb-2"></div>
        </div>
        <div class="col">
          <label class="form-label">Copia del titolo abilitativo</label>
          <input id="enti_preposti_file_${i}" type="file" class="form-control"
                 name="enti_preposti_file" />
          <div id="errore_enti_preposti_file_${i}" class="mb-2"></div>
        </div>
        <div class="col-auto">
          <button type="button" class="btn btn-outline-danger btn-sm ep-remove-row" title="Elimina riga">
            <i class="bi bi-trash"></i> Rimuovi
          </button>
        </div>
      </div>
    </li>
  `);

  // limiti/accettazione file
  li.find('input[type="file"]').attr('accept','application/pdf');

  // Append
  $("#ep-list").append(li);
});

// Rimuovi riga (solo righe aggiuntive, non la #1)
$(document).on("click", ".ep-remove-row", function(){
  $(this).closest(".ep-row").remove();
});

// Abilita/disabilita il file in base alla presenza del titolo (come volevi tu)
$(document).on("input", "#ep-list input[id^=enti_preposti_input]", function(){
  const $row = $(this).closest(".ep-row");
  const hasText = ($(this).val() || "").trim() !== "";
  $row.find('input[type="file"]').prop("disabled", !hasText);
});

// Quando si cambia opzione nei radio mostriamo la lista dinamica
$("input[name='acquisizione-pareri']").on("change", function () {
  const val = $(this).val(); // "no-necessita" | "necessita"
  // memorizza scelta per il bottone "Crea files"
  window.tipo_cantierabilita = val;

  // toggle blocchi
  $("#upload_perizia_progettista").toggleClass("d-none", val !== "no-necessita");
  $("#enti-preposti-lista").toggleClass("d-none", val !== "necessita");

  // opzionale: nascondi sempre l'altra tabella (non usata)
  $("#enti-preposti-tabella").addClass("d-none");
});

$(document).on("change", "input[type=file]", function() {
  const MAX_BYTES = 5 * 1024 * 1024; // 5 MB
  const $input = $(this);
  const files = this.files;
  if (!files || files.length === 0) {
    return; // nessun file selezionato, ok
  }
  const f = files[0];
  if (f.size > MAX_BYTES) {
    // File troppo grande
    $input.addClass("is-invalid");
    // Mostra messaggio d’errore vicino all’input
    const $err = $input.next(".invalid-feedback");
    if ($err.length === 0) {
      // se non esiste, crealo
      $input.after(`<div class="invalid-feedback d-block">Il file "${f.name}" supera 5 MB: riduci la dimensione.</div>`);
    } else {
      $err.addClass("d-block").text(`Il file "${f.name}" supera 5 MB: riduci la dimensione.`);
    }
  } else {
    // File ok
    $input.removeClass("is-invalid");
    $input.next(".invalid-feedback").removeClass("d-block").text("");
  }
});